<?PHP 
/**
* @package direct-as-a-service
* @subpackage views
*/

	$this->load->view('api/header'); 
	$this->load->view('api/nav'); 
	$this->load->helper('form');
	$count = 0;
?>
				<h1>Authorized Application List</h1>
				<div class="column">
					<?PHP if(isset($message)) { echo '<div class="message">'.$message.'</div>'; } ?>
					<?PHP if(isset($error_message)) { echo '<div class="message_error">'.$error_message.'</div>'; } ?>
					<?PHP if(isset($success_message)) { echo '<div class="message_success">'.$success_message.'</div>'; } ?>
					<div id="message-success" class="message_success display_none">&nbsp;</div>
					<div id="message-error" class="message_error display_none">&nbsp;</div>
					
					<?PHP
						echo form_open('/user_settings/application_list',array('id'=>'app_list_form'));
						$hidden_inputs = array(
							'page_select_correction' => '',
							'prefix' => '',
							'active_page_on_bar' => '',
							'active_page_select' => '',
							'active_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
						);
						echo form_hidden($hidden_inputs,TRUE);
						echo form_close();
					?>
					<div id="tabs" class="column ui-tabs ui-widget ui-widget-content ui-corner-all">
						<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
							<li class="reports-tab ui-state-default ui-corner-top ui-tabs-selected ui-state-active"><a href="/user_settings/application_list">Authorized Application List</a></li>
							<li class="reports-tab ui-state-default ui-corner-top"><a href="/user_settings/account_edit">Account</a></li>
						</ul>
						<div class="tab-content" id="active">
							<p>This table lists the authorized applications.</p>
							
							<?php if (sizeof($active_list) == 0) { ?>
								<div class="message">You currently have no active applications.</div>
							<?php }else{ ?>
								<?PHP echo form_open('/user_settings/application_list',array('id'=>'app_list_form')); ?>
									<div class="pagination">
										<span><?php if(isset($active_size)) { echo $active_size; } else {echo "0";}?> result<?php if(isset($active_size) && $active_size !== 1) { echo 's'; } ?></span>
										<label class="hidden_context">Page Selecting Buttons</label>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($active_pagination_bar)) { echo $active_pagination_bar; }?></span>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($active_items_per_page_dropdown)) { echo $active_items_per_page_dropdown; }?></span>
										<div style="float:right; position:relative">
											<label class="hidden_context">Page Selector</label>Page
											<select id="active_page_select" name="active_page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $active_items_per_page;?>, 'active_');" >
												<?php for($count = 1;$count <= $active_num_pages;$count++){ ?>
												<option value="<?php echo $count;?>" <?php if ($count == $active_cur_page){echo "selected";}?>><?php echo $count;?></option>
												<?php  } ?>
											</select>
											<span class="text"> of <?php echo $active_num_pages;?></span>
										</div>
									</div>
								<?PHP echo form_close(); ?>
								<table class="display">
									<tr>
										<th width="90%">Name</th>
										<th width="10%" class="displaylast">Action</th>
									</tr>
									<?php $count = 0; foreach($active_list as $app){ ?>
										<tr>
											<td>
												<a href="/user_settings/webservice_access_edit/null/<?php echo $app->id; ?>/<?php if($active_cur_page){echo $active_cur_page;}else{echo 1;} ?>/<?php if($active_items_per_page){echo $active_items_per_page;}else{echo $ITEMS_PER_PAGE_DEFAULT;}?>/"><?php echo $app->name; ?></a>&nbsp;
												<?php if ($app->url){?>
													<br/><a target="_blank" href="<?php echo $app->url; ?>"><?php echo $app->url; ?></a>&nbsp;
												<?php } ?>
												<?php if ($app->description){?>
													<br/><?php echo $app->description; ?>&nbsp;
												<?php } ?>
											</td>
											<td>
													<?PHP echo form_hidden('app_id',$app->id,'app_id'); ?>
													<div class="center">
														<a href="/user_settings/webservice_access_edit/null/<?php echo $app->id; ?>/<?php if($active_cur_page){echo $active_cur_page;}else{echo 1;} ?>/<?php if($active_items_per_page){echo $active_items_per_page;}else{echo $ITEMS_PER_PAGE_DEFAULT;}?>/" title="Edit Web Service Access: <?php echo $app->name; ?>"><img src="/images/icons/application_edit.png" alt="Edit Application: <?php echo $app->name; ?>" /></a>
													</div>
											</td>
										</tr>
									<?php $count++; } ?>
								</table>
								<?PHP echo form_open('/user_settings/application_list',array('id'=>'app_list_form')); ?>
									<div class="pagination">
										<span><?php if(isset($active_size)) { echo $active_size; } else {echo "0";}?> result<?php if(isset($active_size) && $active_size !== 1) { echo 's'; } ?></span>
										<label class="hidden_context">Page Selecting Buttons</label>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($active_pagination_bar)) { echo $active_pagination_bar; }?></span>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php if(isset($active_items_per_page_dropdown)) { echo $active_items_per_page_dropdown; }?></span>
										<div style="float:right; position:relative">
											<label class="hidden_context">Page Selector</label>Page
											<select id="active_page_select" name="active_page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $active_items_per_page;?>, 'active_');" >
												<?php for($count = 1;$count <= $active_num_pages;$count++){ ?>
												<option value="<?php echo $count;?>" <?php if ($count == $active_cur_page){echo "selected";}?>><?php echo $count;?></option>
												<?php  } ?>
											</select>
											<span class="text"> of <?php echo $active_num_pages;?></span>
										</div>
									</div>
								<?PHP echo form_close(); ?>
							<?php } ?>
						</div>
						
						
					</div>
				</div>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>

